///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _SQLTEMPLATE_CPP
#define _SQLTEMPLATE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "../SharedClasses/CMemPool/CMemPool.H"

#include "Debug.H"
#include "../SharedSource/NSWFL.H"
#include "Common.H"

#include "SQLTemplate.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReplStr(char *sBuf, const char *sReplace, const char *sWith)
{
	char *sReplBuf = NULL;
	int iBufSz = strlen(sBuf);
	int iPos = 0;
	int iOccurrences  = 0; // The number of time "sReplace" occurs in "sBuf".
	int iMemRequired = 0;
	int iMemDiff = strlen(sWith) - strlen(sReplace);

	while( (iPos = InStrEx(sReplace, sBuf, iBufSz, iPos)) > 0)
	{
		iPos++;
		iOccurrences++;
	}

	if(iOccurrences == 0)
	{
		return 0;
	}

	iMemRequired = (iBufSz + (iMemDiff * iOccurrences)) + 1;

	sReplBuf = (char *) gMem.Allocate(sizeof(char), iMemRequired);
	Assert(!sReplBuf, "Memory Allocation Error.");

	ReplaceStrings(sBuf, sReplace, sWith, sReplBuf);
	memcpy(sBuf, sReplBuf, iMemRequired);
	gMem.Free(sReplBuf);

	return iOccurrences;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool BuildSQLFromTemplate(const char *sScriptPath, const char *sFile, char *sSQL, LPSQLTEMPLATE lpSQLTemp)
{
	FILE *hSource = NULL;
	char sFilePath[MAX_PATH];
	int iLen = 0;

	sprintf_s(sFilePath, sizeof(sFilePath), "%s\\SQL\\%s", sScriptPath, sFile);
	if(fopen_s(&hSource, sFilePath, "rb") != 0)
	{
		WriteSysLogEx("Failed to open the SQL Template file.", EVENT_ERROR);
		return false;
	}

	iLen = Get_FileSize(sFilePath);
	fread(sSQL, iLen, sizeof(char), hSource);
	sSQL[iLen] = '\0';

	fclose(hSource);

	if(lpSQLTemp != NULL)
	{
		if(lpSQLTemp->iMask &SQLTMP_DB)    ReplStr(sSQL, "{SQLExch_TAG_DB}", lpSQLTemp->sDB);
		if(lpSQLTemp->iMask &SQLTMP_TABLE) ReplStr(sSQL, "{SQLExch_TAG_TABLE}", lpSQLTemp->sTable);
		if(lpSQLTemp->iMask &SQLTMP_DBDIR) ReplStr(sSQL, "{SQLExch_TAG_DBDIR}", lpSQLTemp->sDBDir);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif